package w83b.w83bBeans;

import java.io.InputStream;
import java.sql.Blob;
import java.sql.ResultSet;
import java.sql.SQLException;

import w83b.util.jdbc.W83bDataBase;
import w83b.w83bDAO.w83bConstantesBD.W83bActasBD;
import w83b.w83bUtilidadesComunes.W83bClsConstantes;

public class W83bDocBeanIncidencia extends W83bBaseBean implements W83bBaseBeanBD{

	private String id="";
	private String  numActa = "";
	private String  numActaTerritorio = "";
	private String  numActaAno = "";
	private String  versionActa = "";
	private String codFase;
	private String codTramite;
	private String nombre="";
	private String longitudDocumento="";
	private Blob fileDataBlob;
	private InputStream fileData;
	private String tipoDocumento="";
	private String fechaRegistro="";
	private String numeroRegistro="";
	private String usuario="";
	private String fecActu;
		
	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}

	public String getNumActa() {
		return numActa;
	}

	public void setNumActa(String numActa) {
		this.numActa = numActa;
	}

	public String getNumActaTerritorio() {
		return numActaTerritorio;
	}

	public void setNumActaTerritorio(String numActaTerritorio) {
		this.numActaTerritorio = numActaTerritorio;
	}

	public String getNumActaAno() {
		return numActaAno;
	}

	public void setNumActaAno(String numActaAno) {
		this.numActaAno = numActaAno;
	}

	public String getVersionActa() {
		return versionActa;
	}
	public void setVersionActa(String versionActa) {
		this.versionActa = versionActa;
	}

	public String getCodFase() {
		return codFase;
	}

	public void setCodFase(String codFase) {
		this.codFase = codFase;
	}

	public String getCodTramite() {
		return codTramite;
	}

	public void setCodTramite(String codTramite) {
		this.codTramite = codTramite;
	}

	public String getNombre() {
		return nombre;
	}

	public void setNombre(String nombre) {
		this.nombre = nombre;
	}

	public String getLongitudDocumento() {
		return longitudDocumento;
	}

	public void setLongitudDocumento(String longitudDocumento) {
		this.longitudDocumento = longitudDocumento;
	}

	public Blob getFileDataBlob() {
		return fileDataBlob;
	}

	public void setFileDataBlob(Blob fileDataBlob) {
		this.fileDataBlob = fileDataBlob;
	}

	public InputStream getFileData() {
		return fileData;
	}

	public void setFileData(InputStream fileData) {
		this.fileData = fileData;
	}

	public String getTipoDocumento() {
		return tipoDocumento;
	}

	public void setTipoDocumento(String tipoDocumento) {
		this.tipoDocumento = tipoDocumento;
	}

	public String getFechaRegistro() {
		return fechaRegistro;
	}

	public void setFechaRegistro(String fechaRegistro) {
		this.fechaRegistro = fechaRegistro;
	}

	public String getNumeroRegistro() {
		return numeroRegistro;
	}

	public void setNumeroRegistro(String numeroRegistro) {
		this.numeroRegistro = numeroRegistro;
	}

	public String getUsuario() {
		return usuario;
	}

	public void setUsuario(String usuario) {
		this.usuario = usuario;
	}

	public String getFecActu() {
		return fecActu;
	}

	public void setFecActu(String fecActu) {
		this.fecActu = fecActu;
	}

	public Object rowToBean(Object o, Object otrosValores) throws Exception {
		ResultSet rs = (ResultSet)o;//NOPMD
		
		this.id=W83bDataBase.getStringFromRS(rs, W83bActasBD.doc_id);
		this.numActa=W83bDataBase.getStringFromRS(rs, W83bActasBD.doc_numActa);
		this.numActaTerritorio=W83bDataBase.getStringFromRS(rs, W83bActasBD.doc_territActa);
		this.numActaAno=W83bDataBase.getStringFromRS(rs, W83bActasBD.doc_anyoActa);
		this.versionActa=W83bDataBase.getStringFromRS(rs, W83bActasBD.doc_versionActa);
		this.codFase=W83bDataBase.getStringFromRS(rs, W83bActasBD.doc_fase);
		this.codTramite=W83bDataBase.getStringFromRS(rs, W83bActasBD.doc_tram);
		this.nombre=W83bDataBase.getStringFromRS(rs, W83bActasBD.doc_nombre);
		this.longitudDocumento=W83bDataBase.getStringFromRS(rs, W83bActasBD.doc_longitud);
		this.fileDataBlob=W83bDataBase.getBlobFromRS(rs, W83bActasBD.doc_documento);
		this.tipoDocumento=W83bDataBase.getStringFromRS(rs, W83bActasBD.doc_tipo);
		this.fechaRegistro=W83bDataBase.getStringFromRS(rs, W83bActasBD.doc_fechaReg);
		this.numeroRegistro=W83bDataBase.getStringFromRS(rs, W83bActasBD.doc_numReg);
		this.usuario=W83bDataBase.getStringFromRS(rs, W83bActasBD.doc_usuario);
		this.fecActu=W83bDataBase.getStringFromRS(rs, W83bActasBD.doc_fechaActualizacion);
		

		return this;
	}

	public W83bDocBean w83bDocBeanIncidenciaToW83bDocBean() throws SQLException{
		W83bDocBean docBean = new W83bDocBean();
		
		docBean.setCodFase(this.codFase);
		docBean.setCodTramite(this.codTramite);
		docBean.setFechaRegistro(this.fechaRegistro);
		docBean.setFileData(null);
		docBean.setFileDataBlob(this.getFileDataBlob());
		docBean.setId(this.id);
		docBean.setNombre(this.nombre);
		docBean.setNumActa(this.numActa);
		docBean.setNumActaAno(this.numActaAno);
		docBean.setNumActaTerritorio(this.numActaTerritorio);
		docBean.setNumeroRegistro(this.numeroRegistro);
		docBean.setTamanyo(Integer.parseInt(this.longitudDocumento));
		docBean.setTipoDocumento(new StringBuffer(W83bClsConstantes.UNO).append(this.tipoDocumento).append("_")
				.append(this.codFase).append("_").append(this.codTramite).toString());
		docBean.setUsuario(this.usuario);
		docBean.setVersionActa(this.versionActa);
		
		return docBean;
	}	
}
